/*
Copyright 2008-2011 Broadcom Corporation

This program isthe proprietary software of Broadcom Corporation and/or its
licensors, and may only be used, duplicated, modifiedor distributed pursuant to
the terms and conditions of a separate, written license agreement executed
between you and Broadcom (an "Authorized License"). Except as set forth in an
Authorized License, Broadcom grants no license (express or implied), right to
use, or waiver of any kind with respect to the Software, and Broadcom expressly
reserves all rights in and to the Software and all intellectual property rights
therein. IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS
SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL
USE OF THE SOFTWARE.

Except as expressly set forth in the Authorized License,

1. This program, including its structure, sequence and organization, constitutes
   the valuable trade secrets of Broadcom, and you shall use all reasonable
   efforts to protect the confidentiality thereof, and to use this information
   only in connection with your use of Broadcom integrated circuit products.

2.TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWAREIS PROVIDED "AS IS" AND
   WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
   WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
   THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMSANY AND ALL IMPLIED WARRANTIES
   OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
   LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
   OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
   USE OR PERFORMANCE OF THE SOFTWARE.

3.TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
   LICENSORS BE LIABLE FOR(i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
   EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
   USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
   THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
   ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
   LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
   ANY LIMITED REMEDY.
*/
/** \file apcm_set_key.h
 *
 * \brief APCM_SET_KEY primitive
 *
 * The APCM_SET_KEY.REQ message is used by the HLE to set the NMK of its
 * STA. Reception of this primitive causes the STA to leave its existing AVLN
 * and restart its power-on network procedure.
 **************************************************/
#ifndef APCM_SET_KEY_H_
#define APCM_SET_KEY_H_

/***************************************************
 *                 Include section
 ***************************************************/
#include "../base_types.h"
#include "definitions.h"

/***************************************************
 *                 Public Typedefs Section
 ***************************************************/

/**
 * \brief If the type of the authorization is use of default NID then uses the
 *        security level of new NMK
*/
typedef struct
{
   t_Key             NMK;  //!< New Network Membership Key
   tE_SecurityLevel  SL;   //!< Security Level of new NMk
} tS_APCM_SET_KEY_USE_DEFAULT_NID_REQ;

/**
 * \brief   If the type of the authorization is use NID to associate with the
 *          new NMK
*/
typedef struct
{
   t_Key NMK; //!< New Network Membership Key
   t_NetId NID; /*!< Network identifier (including security level) to associate
                   with this NMK, or indicate to use the default NID. */
} tS_APCM_SET_KEY_USE_NID_ASSOC_REQ;


/** \brief Result of the operation */
typedef enum
{
  AVLNMGR_SUCCESS,      /**< Success state */
  AVLNMGR_FAIL,         /**< Fail state */
  AVLNMGR_END_POWERON   /**< End of Power-ON Network Discovery procedure */
} tE_APCM_SET_KEY_CNF;


/** \brief This is the struct to hold the transaction response */
typedef struct
{
    tE_TransactionResult   result;   //!< Transaction result
    tS_APL2C_ERROR_CNF     err;      //!< APL2C_ERROR_CNF
    tE_APCM_SET_KEY_CNF    cnf;      //!< APCM_SET_KEY_CNF
} tS_APCM_SET_KEY_Result;

/***************************************************
 *         Public Function Prototypes Section
 ***************************************************/

/**
 * \brief            Execute APCM_SET_KEY using default NID
 *
 * \param req        (in)  REQ primitive
 * \param p_result   (out) Transaction result
*/
void Exec_APCM_SET_KEY_USE_DEFAULT_NID(
   const tS_APCM_SET_KEY_USE_DEFAULT_NID_REQ req,
   tS_APCM_SET_KEY_Result* p_result);

/**
 * \brief            Execute APCM_SET_KEY using NID associate with the new NMK
 *
 * \param req        (in)  REQ primitive
 * \param p_result   (out) Transaction result
*/
void Exec_APCM_SET_KEY_USE_NID_ASSOC(
   const tS_APCM_SET_KEY_USE_NID_ASSOC_REQ req,
   tS_APCM_SET_KEY_Result* p_result);

#endif /*APCM_SET_KEY_H_*/
